/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.MishapDivideByZero;
import at.petrak.hexcasting.common.casting.arithmetic.operator.OperatorLog;
import at.petrak.hexcasting.common.casting.arithmetic.operator.OperatorUtilsKt;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u00158\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/DoubleArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "<init>", "()V", "", "arithName", "()Ljava/lang/String;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "pattern", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "getOperator", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "Ljava/util/function/DoubleUnaryOperator;", "op", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "make1", "(Ljava/util/function/DoubleUnaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "Ljava/util/function/DoubleBinaryOperator;", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "make2", "(Ljava/util/function/DoubleBinaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "", "kotlin.jvm.PlatformType", "opTypes", "()Ljava/util/List;", "Lat/petrak/hexcasting/api/casting/arithmetic/predicates/IotaMultiPredicate;", "ACCEPTS", "Lat/petrak/hexcasting/api/casting/arithmetic/predicates/IotaMultiPredicate;", "getACCEPTS", "()Lat/petrak/hexcasting/api/casting/arithmetic/predicates/IotaMultiPredicate;", "OPS", "Ljava/util/List;", "hexcasting-fabric-1.20.1"})
public final class DoubleArithmetic
implements Arithmetic {
    @NotNull
    public static final DoubleArithmetic INSTANCE = new DoubleArithmetic();
    @JvmField
    @NotNull
    public static final List<HexPattern> OPS;
    @NotNull
    private static final IotaMultiPredicate ACCEPTS;

    private DoubleArithmetic() {
    }

    @NotNull
    public final IotaMultiPredicate getACCEPTS() {
        return ACCEPTS;
    }

    @Override
    @NotNull
    public String arithName() {
        return "double_math";
    }

    @NotNull
    public List<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ADD)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.SUB)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.MUL)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.DIV)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$3);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$4);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.POW)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$5);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.FLOOR)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$6);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.CEIL)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$7);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.SIN)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$8);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.COS)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$9);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.TAN)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$10);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ARCSIN)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$11);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ARCCOS)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$12);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ARCTAN)) {
            operator = this.make1(DoubleArithmetic::getOperator$lambda$13);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ARCTAN2)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$14);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.LOG)) {
            operator = OperatorLog.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.MOD)) {
            operator = this.make2(DoubleArithmetic::getOperator$lambda$15);
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    @NotNull
    public final OperatorUnary make1(@NotNull DoubleUnaryOperator op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new OperatorUnary(ACCEPTS, arg_0 -> DoubleArithmetic.make1$lambda$16(op, arg_0));
    }

    @NotNull
    public final OperatorBinary make2(@NotNull DoubleBinaryOperator op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new OperatorBinary(ACCEPTS, (arg_0, arg_1) -> DoubleArithmetic.make2$lambda$17(op, arg_0, arg_1));
    }

    private static final double getOperator$lambda$0(double a, double b) {
        return a + b;
    }

    private static final double getOperator$lambda$1(double a, double b) {
        return a - b;
    }

    private static final double getOperator$lambda$2(double a, double b) {
        return a * b;
    }

    private static final double getOperator$lambda$3(double a, double b) {
        if (b == 0.0) {
            throw MishapDivideByZero.Companion.of$default(MishapDivideByZero.Companion, a, b, null, 4, null);
        }
        return a / b;
    }

    private static final double getOperator$lambda$4(double a) {
        return Math.abs(a);
    }

    private static final double getOperator$lambda$5(double a, double b) {
        if (a < 0.0 && !DoubleIota.tolerates(Math.floor(b), b)) {
            throw MishapDivideByZero.Companion.of(a, b, "exponent");
        }
        return Math.pow(a, b);
    }

    private static final double getOperator$lambda$6(double a) {
        return Math.floor(a);
    }

    private static final double getOperator$lambda$7(double a) {
        return Math.ceil(a);
    }

    private static final double getOperator$lambda$8(double a) {
        return Math.sin(a);
    }

    private static final double getOperator$lambda$9(double a) {
        return Math.cos(a);
    }

    private static final double getOperator$lambda$10(double a) {
        if (Math.cos(a) == 0.0) {
            throw MishapDivideByZero.Companion.tan(a);
        }
        return Math.tan(a);
    }

    private static final double getOperator$lambda$11(double a) {
        return Math.asin(OperatorUtilsKt.asDoubleBetween(a, -1.0, 1.0, 0));
    }

    private static final double getOperator$lambda$12(double a) {
        return Math.acos(OperatorUtilsKt.asDoubleBetween(a, -1.0, 1.0, 0));
    }

    private static final double getOperator$lambda$13(double a) {
        return Math.atan(a);
    }

    private static final double getOperator$lambda$14(double a, double b) {
        return Math.atan2(a, b);
    }

    private static final double getOperator$lambda$15(double a, double b) {
        if (b == 0.0) {
            throw MishapDivideByZero.Companion.of$default(MishapDivideByZero.Companion, a, b, null, 4, null);
        }
        return a % b;
    }

    private static final Iota make1$lambda$16(DoubleUnaryOperator $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        IotaType<DoubleIota> iotaType = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"DOUBLE");
        return new DoubleIota($op.applyAsDouble(Operator.Companion.downcast(i, iotaType).getDouble()));
    }

    private static final Iota make2$lambda$17(DoubleBinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<DoubleIota> iotaType = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"DOUBLE");
        double d = Operator.Companion.downcast(i, iotaType).getDouble();
        IotaType<DoubleIota> iotaType2 = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"DOUBLE");
        return new DoubleIota($op.applyAsDouble(d, Operator.Companion.downcast(j, iotaType2).getDouble()));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.ADD, Arithmetic.SUB, Arithmetic.MUL, Arithmetic.DIV, Arithmetic.ABS, Arithmetic.POW, Arithmetic.FLOOR, Arithmetic.CEIL, Arithmetic.SIN, Arithmetic.COS, Arithmetic.TAN, Arithmetic.ARCSIN, Arithmetic.ARCCOS, Arithmetic.ARCTAN, Arithmetic.ARCTAN2, Arithmetic.LOG, Arithmetic.MOD};
        OPS = CollectionsKt.listOf((Object[])objectArray);
        IotaMultiPredicate iotaMultiPredicate = IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.DOUBLE));
        Intrinsics.checkNotNullExpressionValue((Object)iotaMultiPredicate, (String)"all(IotaPredicate.ofType(HexIotaTypes.DOUBLE))");
        ACCEPTS = iotaMultiPredicate;
    }
}

